@extends('frontend.layouts.main')

@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h4>Terms & Conditions</h4>

        </div>

    </div>
    

</div>

<div class="container-fluid mt-3">

    @include('flash_msg')



    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <div class="table-responsive">

                        <table class="table table-border table-hover table-sm" id="tabl">
                            <thead>

                                <tr>

                                    <th>#</th>

                                    <th>Terms Conditions</th>

                                    <th>Action</th>

                                </tr>

                            </thead>

                            <tbody>

                                @if(!empty($datas))

                                    @foreach($datas as $key => $value)

                                        <tr>
                                            
                                            <td>{{ ++$key }}</td>

                                            <td>{{ Illuminate\Support\Str::limit(strip_tags($value->terms_condition), 80) }}</td>



                                            <td>
                                                <a href="{{ route('terms_condition.edit',encrypt($value->id)) }}" title="Edit" alt="Edit" class="color-green">
                                                    <i class="fas fa-edit"></i> 
                                                </a>
                                               
                                            </td>

                                        </tr>

                                    @endforeach

                                @endif
                                
                            </tbody>

                            <tfoot>

                                <tr>
                                    <th>#</th>

                                     <th>Terms Conditions</th>

                                    <th>Action</th>
                                </tr>


                            </tfoot>

                        </table>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
</main>

<script type="text/javascript">
     $(document).ready(function () {
      $('#tabl').DataTable({
         
      });
  });
  </script>
  <!-- End #main -->

@endsection
