@extends('frontend.layouts.main')

@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h4>Report</h4>

        </div>

    </div>
   
    
</div>

<div class="container-fluid">

    @include('flash_msg')

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <div class="table-responsive">

                        <table class="table table-border table-hover table-sm" id="tabl">
                            <thead>

                                <tr>

                                    <th>#</th>

                                    <th>Location</th>

                                    <th>Name</th>

                                    <th>Report</th>

                                    <th>Date</th>

                                    <th>Action</th>

                                </tr>

                            </thead>

                            <tbody>

                                @if(!empty($datas))

                                    @foreach($datas as $key => $value)

                                        <tr>
                                            
                                            <td>{{ ++$key }}</td>

                                            <td>{{ $value->location }}</td>

                                            <td>{{ $value->User->name ?? 'N/A' }}</td>

                                            <td>{{ $value->message }}</td>

                                            <td>{{ $value->date }}</td>

                                            <td>
                                                <a href="{{ route('report.edit',encrypt($value->id)) }}" title="Edit" alt="Edit" class="color-green">
                                                    <i class="fas fa-edit"></i> 
                                                </a>
                                                |
                                                <a href="{{ route('report.delete',encrypt($value->id)) }}" onclick="return confirm('Are you sure delete this?')" title="Delete" alt="Delete" class="color-green">
                                                    <i class="fas fa-trash-alt"></i>
                                                </a>
                                            </td>

                                        </tr>

                                    @endforeach

                                @endif
                                
                            </tbody>

                            <tfoot>

                                <tr>
                                    <th>#</th>

                                    <th>Location</th>

                                     <th>Name</th>

                                    <th>Report</th>

                                    <th>Date</th>

                                    <th>Action</th>
                                </tr>


                            </tfoot>

                        </table>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
</main><!-- End #main -->

<script type="text/javascript">
     $(document).ready(function () {
      $('#tabl').DataTable({
         
      });
  });
  </script>

@endsection
