@extends('frontend.layouts.main')

@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h4>Games Playes Lists</h4>

        </div>

    </div>
   
    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

        <a href="{{ route('games_results') }}">

            <button type="button" class="btns success-btn btn-sm">

                <i class="fas fa-arrow-left"></i> Back

            </button>

        </a>

    </div>
    

</div>

<div class="row page-titles mx-0 mt-lg-4">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <p><b>Games Name: </b>{{$games->name}}</p>

        </div>

    </div>
    

</div>

<div class="container-fluid mt-3">

    @include('flash_msg')



    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <div class="table-responsive">

                        <table class="table table-border table-hover table-sm" id="tabl">
                            <thead>

                                <tr>

                                    <th>#</th>

                                    <th>Name</th>

                                    <th>Email</th>

                                    <th>Phone</th>

                                    <th>Attribute</th>

                                    <th>Answer/Question</th>

                                    <th>Winners</th>

                                </tr>

                            </thead>

                            <tbody>

                                @if(!empty($game_results))

                                    @foreach($game_results as $key => $value)

                                        <tr>

                                            <td>{{ ++$key }}</td>
                                            
                                            <td>{{ $value->name }}</td>

                                            <td>{{ $value->email }}</td>

                                            <td>{{ $value->phone }}</td>

                                            <td>{{ $value->label }}/{{ $value->value }}</td>

                                            <td>{{ $value->answer }}/{{ $value->question }}</td>

                                            <td>
                                                @if($value->winners=='1')
                                                    <a href="{{url('winners/'.$value->id)}}">
                                                        <button class="btns success-btn btn-sm">Winner</button>
                                                    </a>
                                                @else
                                                    <a href="{{url('winners/'.$value->id)}}">
                                                        <button class="btn btn-danger btn-sm">Loss</button>
                                                    </a>
                                                @endif
                                            </td>


                                        </tr>

                                    @endforeach

                                @endif
                                
                            </tbody>

                            <tfoot>

                                <tr>

                                    <th>#</th>

                                    <th>Name</th>

                                    <th>Email</th>

                                    <th>Phone</th>

                                    <th>Attribute</th>

                                    <th>Answer/Question</th>

                                    <th>Winners</th>

                                </tr>


                            </tfoot>

                        </table>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>

</main>

<script type="text/javascript">
     $(document).ready(function () {
      $('#tabl').DataTable({
         
      });
  });
  </script>
  <!-- End #main -->

@endsection
