@extends('frontend.layouts.main')

@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h4>Games</h4>

        </div>

    </div>
    

</div>

<div class="container-fluid mt-3">

    @include('flash_msg')



    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <div class="table-responsive">

                        <table class="table table-border table-hover table-sm" id="tabl">
                            <thead>

                                <tr>

                                    <th>#</th>

                                    <th>Name</th>

                                    <th>Image</th>

                                    <th>Announcement Date</th>

                                    <th>Action</th>

                                </tr>

                            </thead>

                            <tbody>

                                @if(!empty($datas))

                                    @foreach($datas as $key => $value)

                                        <tr>
                                            
                                            <td>{{ ++$key }}</td>

                                            <td>{{ $value->name }}</td>

                                            <td>

                                                @if($value->image)
                                                <img src="{{ url('/uploads/games/'.$value->image) }}" height="50" width="50">
                                                @else
                                                      Null 
                                                @endif

                                            </td>

                                            <td>{{ date("d-m-Y", strtotime($value->announcement_date)) }}</td>


                                            <td>

                                                <a href="{{ route('show.lists.players', encrypt($value->id)) }}" title="Show Lists Players" alt="Show Lists Players" class="color-green">
                                                    <i class="fas fa-eye"></i> 
                                                </a>|

                                                 <a href="{{ route('show.winners', encrypt($value->id)) }}" title="Show Winners" alt="Show Winners" class="color-green">
                                                    <i class="fas fa-cog"></i> 
                                                </a>

                                               
                                            </td>

                                        </tr>

                                    @endforeach

                                @endif
                                
                            </tbody>

                            <tfoot>

                                <tr>
                                    <th>#</th>

                                    <th>Name</th>

                                    <th>Image</th>

                                    <th>Announcement Date</th>

                                    <th>Action</th>
                                </tr>


                            </tfoot>

                        </table>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
</main>

<script type="text/javascript">
     $(document).ready(function () {
      $('#tabl').DataTable({
         
      });
  });
  </script>
  <!-- End #main -->

@endsection
