@extends('frontend.layouts.main')

@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h4>Games Question</h4>

        </div>

    </div>
   
    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

        <a href="{{ route('games') }}">

            <button type="button" class="btns success-btn btn-sm">

                <i class="fas fa-arrow-left"></i> Back

            </button>

        </a>

    </div>
    

</div>

<div class="row page-titles mx-0 mt-lg-4">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <p><b>Games Name: </b>{{$games->name}}</p>

        </div>

    </div>
   
    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

        <button type="button" class="btn btn-primary" data-toggle="modal" data-target=".add-question"><i class="fas fa-plus"></i> Add Games Question</button>


    </div>
    

</div>

<div class="container-fluid mt-3">

    @include('flash_msg')



    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <div class="table-responsive">

                        <table class="table table-border table-hover table-sm" id="tabl">
                            <thead>

                                <tr>

                                    <th>#</th>

                                    <th>Question</th>

                                    <th>Action</th>

                                </tr>

                            </thead>

                            <tbody>

                                @if(!empty($datas))

                                    @foreach($datas as $key => $value)

                                        <tr>
                                            
                                            <td>{{ ++$key }}</td>

                                            <td>{{ Illuminate\Support\Str::limit(strip_tags($value->question), 80) }}</td>


                                            <td>

                                                <a href="#" data-toggle="modal" data-target="#editquestion-{{ $value->id }}" title="Edit" alt="Edit" class="color-green">
                                                    <i class="fas fa-edit"></i> 
                                                </a>|

                                                <a href="{{ route('games_question.delete',encrypt($value->id)) }}" onclick="return confirm('Are you sure delete this?')" title="Delete" alt="Delete" class="color-green">
                                                    <i class="fas fa-trash-alt"></i>
                                                </a>
                                               
                                            </td>

                                        </tr>

                                        <!-- model question edit -->

                                            <div class="modal fade" id="editquestion-{{$value->id}}" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
                                              <div class="modal-dialog modal-lg">
                                                <div class="modal-content">
                                                    <div class="modal-header" >
                                                      <h5 class="modal-title" id="exampleModalLabel">Edit Question</h5>
                                                      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                      </button>
                                                    </div> 

                                                      <form action="{{route('games_question.update',$value->id)}}" method="POST" class="form-sample" enctype="multipart/form-data">
                                                       {{ csrf_field() }}

                                                    <div class="row p-4">
                                                        <div class="form-group col-lg-12">
                                                            <label>Question <span class="text-danger">*</span></label>
                                                            <input type="text" class="form-control" name="question" value="{{$value->question}}"  placeholder="Enter Question Here.." required>
                                                            <span class="text-danger"> @error('question'){{ $question }}@enderror </span>
                                                        </div>

                                                        <div class="form-group col-lg-8">
                                                        <label>Option(1)<span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" name="option_1" value="{{$value->option_1}}" placeholder="Enter Answer Here.." required>
                                                        <span class="text-danger">@error('name'){{$message}}@enderror</span>
                                                    </div>

                                                    <div class="form-group col-lg-4">
                                                        <label>Answer(Yes/No) <span class="text-danger">*</span></label>
                                                        <select class="form-control dropdown-toggle" name="answer_1" type="button" data-toggle="dropdown" required>
                                                            <option value="">Select Answer</option>
                                                            <option value="yes" {{$value->answer_1 === 'yes' ? 'selected' : ''}}>Yes</option>
                                                            <option value="no" {{$value->answer_1 === 'no' ? 'selected' : ''}}>No</option>
                                                        </select>
                                                    </div>

                                                    <div class="form-group col-lg-8">
                                                        <label>Option(2)<span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" name="option_2" value="{{$value->option_2}}" placeholder="Enter Answer Here.." required>
                                                        <span class="text-danger"> @error('name'){{ $message }}@enderror </span>
                                                    </div>

                                                    <div class="form-group col-lg-4">
                                                        <label>Answer(Yes/No) <span class="text-danger">*</span></label>
                                                         <select class=" form-control dropdown-toggle" name="answer_2" type="button" data-toggle="dropdown" required>
                                                            <option value="">Select Answer</option>
                                                            <option value="yes" {{$value->answer_2 === 'yes' ? 'selected' : ''}}>Yes</option>
                                                            <option value="no" {{$value->answer_2 === 'no' ? 'selected' : ''}}>No</option>
                                                        </select>
                                                    </div>


                                                    <div class="form-group col-lg-8">
                                                        <label>Option(3)<span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" name="option_3"  value="{{$value->option_3}}" placeholder="Enter Answer Here.." required>
                                                        <span class="text-danger"> @error('name'){{ $message }}@enderror </span>
                                                    </div>

                                                    <div class="form-group col-lg-4">
                                                        <label>Answer(Yes/No) <span class="text-danger">*</span></label>
                                                         <select class=" form-control dropdown-toggle" name="answer_3" type="button" data-toggle="dropdown" required>
                                                            <option value="">Select Answer</option>
                                                            <option value="yes" {{$value->answer_3 === 'yes' ? 'selected' : ''}}>Yes</option>
                                                            <option value="no" {{$value->answer_3 === 'no' ? 'selected' : ''}}>No</option>
                                                        </select>
                                                    </div>

                                                    <div class="form-group col-lg-8">
                                                        <label>Option(4)<span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" name="option_4"  value="{{$value->option_4}}" placeholder="Enter Answer Here.." required>
                                                        <span class="text-danger"> @error('name'){{ $message }}@enderror </span>
                                                    </div>

                                                    <div class="form-group col-lg-4">
                                                        <label>Answer(Yes/No) <span class="text-danger">*</span></label>
                                                         <select class=" form-control dropdown-toggle" name="answer_4" type="button" data-toggle="dropdown" required>
                                                            <option value="">Select Answer</option>
                                                            <option value="yes" {{$value->answer_4 === 'yes' ? 'selected' : ''}}>Yes</option>
                                                            <option value="no" {{$value->answer_4 === 'no' ? 'selected' : ''}}>No</option>
                                                        </select>
                                                    </div>
                                                    <div class="modal-footer ">
                                                      <button type="button" class="btns primary-btn" data-dismiss="modal">Close</button>
                                                      <button type="submit" class="btns primary-btn">Add</button>
                                                    </div>
                                                  </form>
                                                     
                                                </div>
                                              </div>
                                            </div>

                                    @endforeach

                                @endif
                                
                            </tbody>

                            <tfoot>

                                <tr>
                                    <th>#</th>

                                    <th>Question</th>

                                    <th>Action</th>
                                </tr>


                            </tfoot>

                        </table>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>

<!-- model question add -->

<div class="modal fade add-question" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
        <div class="modal-header" >
          <h5 class="modal-title" id="exampleModalLabel">Add Question</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div> 

          <form action="{{route('games_question.store')}}" method="POST" class="form-sample" enctype="multipart/form-data">
         {{ csrf_field() }}

          <input type="hidden" name="game_id" value="{{ $games->id }}">


        <div class="row p-4">
            <div class="form-group col-lg-12">
                <label>Question <span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="question"  placeholder="Enter Question Here.." required>
                <span class="text-danger"> @error('question'){{ $question }}@enderror </span>
            </div>


            <div class="form-group col-lg-8">
                <label>Option(1)<span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="option_1"  placeholder="Enter Answer Here.." required>
                <span class="text-danger"> @error('name'){{ $message }}@enderror </span>
            </div>

            <div class="form-group col-lg-4">
                <label>Answer(Yes/No) <span class="text-danger">*</span></label>
                 <select class=" form-control dropdown-toggle" name="answer_1" type="button" data-toggle="dropdown" required>
                    <option value="">Select Answer</option>
                    <option value="yes">Yes</option>
                    <option value="no">No</option>
                </select>
            </div>

            <div class="form-group col-lg-8">
                <label>Option(2)<span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="option_2" placeholder="Enter Answer Here.." required>
                <span class="text-danger"> @error('name'){{ $message }}@enderror </span>
            </div>

            <div class="form-group col-lg-4">
                <label>Answer(Yes/No) <span class="text-danger">*</span></label>
                 <select class=" form-control dropdown-toggle" name="answer_2" type="button" data-toggle="dropdown" required>
                    <option value="">Select Answer</option>
                    <option value="yes">Yes</option>
                    <option value="no">No</option>
                </select>
            </div>


            <div class="form-group col-lg-8">
                <label>Option(3)<span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="option_3"  placeholder="Enter Answer Here.." required>
                <span class="text-danger"> @error('name'){{ $message }}@enderror </span>
            </div>

            <div class="form-group col-lg-4">
                <label>Answer(Yes/No) <span class="text-danger">*</span></label>
                 <select class=" form-control dropdown-toggle" name="answer_3" type="button" data-toggle="dropdown" required>
                    <option value="">Select Answer</option>
                    <option value="yes">Yes</option>
                    <option value="no">No</option>
                </select>
            </div>

            <div class="form-group col-lg-8">
                <label>Option(4)<span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="option_4" placeholder="Enter Answer Here.." required>
                <span class="text-danger"> @error('name'){{ $message }}@enderror </span>
            </div>

            <div class="form-group col-lg-4">
                <label>Answer(Yes/No) <span class="text-danger">*</span></label>
                 <select class=" form-control dropdown-toggle" name="answer_4" type="button" data-toggle="dropdown" required>
                    <option value="">Select Answer</option>
                    <option value="yes">Yes</option>
                    <option value="no">No</option>
                </select>
            </div>
        </div>
        <div class="modal-footer ">
          <button type="button" class="btns primary-btn" data-dismiss="modal">Close</button>
          <button type="submit" class="btns primary-btn">Add</button>
        </div>
      </form>
         
    </div>
  </div>
</div>




</main>

<script type="text/javascript">
     $(document).ready(function () {
      $('#tabl').DataTable({
         
      });
  });
  </script>
  <!-- End #main -->

@endsection
