@extends('frontend.layouts.main')

@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h4>Games Attribute</h4>

        </div>

    </div>
   
    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

        <a href="{{ route('games') }}">

            <button type="button" class="btns success-btn btn-sm">

                <i class="fas fa-arrow-left"></i> Back

            </button>

        </a>

    </div>
    

</div>

<div class="row page-titles mx-0 mt-lg-4">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <p><b>Games Name: </b>{{$games->name}}</p>

        </div>

    </div>
   
    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

        <button type="button" class="btn btn-primary" data-toggle="modal" data-target=".add-attribute"><i class="fas fa-plus"></i> Add Attribute</button>


    </div>
    

</div>

<div class="container-fluid mt-3">

    @include('flash_msg')

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <div class="table-responsive">

                        <table class="table table-border table-hover table-sm" id="attribute-table">
                            <thead>

                                <tr>

                                    <th>#</th>

                                    <th>label</th>

                                    <th>Value</th>

                                    <th>Action</th>

                                </tr>

                            </thead>

                            <tbody>

                                @if(!empty($attribute))

                                    @foreach($attribute as $key => $value)

                                        <tr>
                                            
                                            <td>{{ ++$key }}</td>

                                            <td>{{ $value->label }}</td>



                                            <td>{{ $value->value }}</td>

                                            <td>

                                                <a href="#" data-toggle="modal" data-target="#editattribute-{{ $value->id }}" title="Edit" alt="Edit" class="color-green">
                                                    <i class="fas fa-edit"></i> 
                                                </a>|

                                                <a href="{{ route('games_attribute.delete',encrypt($value->id)) }}" onclick="return confirm('Are you sure delete this?')" title="Delete" alt="Delete" class="color-green">
                                                    <i class="fas fa-trash-alt"></i>
                                                </a>
                                               
                                            </td>

                                        </tr>

                                        <!-- model question edit -->

                                            <div class="modal fade" id="editattribute-{{$value->id}}" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
                                                <div class="modal-dialog modal-lg">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLabel">Edit Attribute</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div> 

                                                        <!-- Form for updating a single attribute -->
                                                        <form action="{{ route('games_attribute.update', $value->id) }}" method="POST" class="form-sample" enctype="multipart/form-data">
                                                            {{ csrf_field() }}

                                                            <div class="row p-4">
                                                                <div class="col-lg-4 mt-2">
                                                                    <label>Label</label>
                                                                </div>
                                                                <div class="col-lg-4 mt-2">
                                                                    <label>Value</label>
                                                                </div>
                                                                <div class="col-lg-4 mt-2">
                                                                </div>
                                                                <div class="col-lg-4 mt-2">
                                                                    <input type="text" name="label" value="{{ $value->label }}" class="form-control" placeholder="Label" required>
                                                                </div>
                                                                <div class="col-lg-4 mt-2">
                                                                    <input type="text" name="value" value="{{ $value->value }}" class="form-control" placeholder="Value" required>
                                                                </div>
                                                            </div>

                                                            <div class="modal-footer">
                                                                <button type="button" class="btns primary-btn" data-dismiss="modal">Close</button>
                                                                <button type="submit" class="btns primary-btn">Update</button> <!-- Changed button text to "Update" -->
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>

                                    @endforeach

                                @endif
                                
                            </tbody>

                            <tfoot>

                                <tr>
                                    <th>#</th>

                                    <th>Label</th>

                                    <th>Value</th>

                                    <th>Action</th>
                                </tr>


                            </tfoot>

                        </table>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>

<!-- Modal -->
<div class="modal fade add-attribute" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Add Attribute</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <form action="{{ route('games_attribute.store') }}" method="POST" class="form-sample" enctype="multipart/form-data">
        {{ csrf_field() }}
        <input type="hidden" name="game_id" value="{{$games->id }}">
        <div class="modal-body">
          <h5 class="document_text text-danger"></h5>
          <div class="row">
            <div class="col-lg-4 mt-2">
              <label>Label</label>
            </div>
            <div class="col-lg-4 mt-2">
              <label>Value</label>
            </div>
            <div class="col-lg-4 mt-2">
            </div>
            <div class="col-lg-4 mt-2">
              <input type="text" name="label[]" class="form-control" placeholder="Label" required>
            </div>
            <div class="col-lg-4 mt-2">
              <input type="text" name="value[]" class="form-control" placeholder="Value" required>
            </div>
            <div class="col-lg-4 mt-2">
              <button class="btn btn-success btn-sm" type="button" onclick="addMore()"><i class="fa fa-plus"></i> Add</button>
            </div>
          </div>
          <div class="addMore">
            <!-- Additional input fields will be appended here -->
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
          <button type="submit" class="btn btn-primary">Add</button>
        </div>
      </form>
    </div>
  </div>
</div>
</main>
<!-- End #main -->

<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.datatables.net/1.11.6/js/jquery.dataTables.min.js"></script>

<script>
    $(document).ready(function() {
        $('#attribute-table').DataTable();
    });
</script>

<script>
  function addMore() {
    var html = `
      <div class="row">
        <div class="col-lg-4 mt-2">
          <input type="text" name="label[]" class="form-control" placeholder="Label" required>
        </div>
        <div class="col-lg-4 mt-2">
          <input type="text" name="value[]" class="form-control" placeholder="Value" required>
        </div>
        <div class="col-lg-4 mt-2">
          <button class="btn btn-success btn-sm" type="button" onclick="addMore()"><i class="fa fa-plus"></i> Add</button>
          <button class="btn btn-danger btn-sm" type="button" onclick="removeField(this)"><i class="fa fa-remove"></i> Remove</button>
        </div>
      </div>`;
    $('.addMore').append(html);
  }

  function removeField(btn) {
    $(btn).closest('.row').remove();
  }
</script>

@endsection
