@extends('frontend.layouts.main')

@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h4>Games</h4>

        </div>

    </div>
   
    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

        <a href="{{ route('game.create') }}">

            <button type="button" class="btns success-btn btn-sm">

                <i class="fas fa-plus"></i> Add Game

            </button>

        </a>

    </div>
    

</div>

<div class="container-fluid mt-3">

    @include('flash_msg')



    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <div class="table-responsive">

                        <table class="table table-border table-hover table-sm" id="tabl">
                            <thead>

                                <tr>

                                    <th>#</th>

                                    <th>Name</th>

                                    <th>Image</th>

                                    <th>Announcement Date</th>

                                    <th>Status</th>

                                    <th>Action</th>

                                </tr>

                            </thead>

                            <tbody>

                                @if(!empty($datas))

                                    @foreach($datas as $key => $value)

                                        <tr>
                                            
                                            <td>{{ ++$key }}</td>

                                            <td>{{ $value->name }}</td>

                                            <td>

                                                @if($value->image)
                                                <img src="{{ url('/uploads/games/'.$value->image) }}" height="50" width="50">
                                                @else
                                                      Null 
                                                @endif

                                            </td>

                                            <td>{{ date("d-m-Y", strtotime($value->announcement_date)) }}</td>

                                            <td>
                                                @if($value->status=='1')
                                                    <a href="{{url('gameactive/'.$value->id)}}">
                                                        <button class="btns success-btn btn-sm">Activate</button>
                                                    </a>
                                                @else
                                                    <a href="{{url('gameactive/'.$value->id)}}">
                                                        <button class="btn btn-danger btn-sm">Deactivate</button>
                                                    </a>
                                                @endif
                                            </td>

                                            <td>

                                                <a href="{{ route('add_attributes', encrypt($value->id)) }}" title="Add Attribute" alt="Add Attribute" class="color-green">
                                                    <i class="fas fa-cog"></i> 
                                                </a>|


                                                <a href="{{ route('add_questions', encrypt($value->id)) }}" title="Add Game" alt="Add Game" class="color-green">
                                                    <i class="fas fa-cog"></i> 
                                                </a>|

                                          

                                                <a href="{{ route('game.edit',encrypt($value->id)) }}" title="Edit" alt="Edit" class="color-green">
                                                    <i class="fas fa-edit"></i> 
                                                </a>|

                                                <a href="{{ route('game.delete',encrypt($value->id)) }}" onclick="return confirm('Are you sure delete this?')" title="Delete" alt="Delete" class="color-green">
                                                    <i class="fas fa-trash-alt"></i>
                                                </a>
                                               
                                            </td>

                                        </tr>

                                    @endforeach

                                @endif
                                
                            </tbody>

                            <tfoot>

                                <tr>
                                    <th>#</th>

                                    <th>Name</th>

                                    <th>Image</th>

                                    <th>Announcement Date</th>

                                    <th>Status</th>

                                    <th>Action</th>
                                </tr>


                            </tfoot>

                        </table>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
</main>

<script type="text/javascript">
     $(document).ready(function () {
      $('#tabl').DataTable({
         
      });
  });
  </script>
  <!-- End #main -->

@endsection
