@extends('frontend.layouts.main')

@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h4>Edit Games</h4>

        </div>

    </div>

     <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

        <a href="{{route('games')}}">

            <button type="button" class="btns success-btn btn-sm">

                <i class="fas fa-arrow-left"></i> Back

            </button>

        </a>

    </div>

</div>

<div class="content-wrapper mt-4">

    @include('flash_msg')

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                     <form action="{{route('game.update',$data->id)}}" method="POST" class="form-sample" enctype="multipart/form-data">
                            {{ csrf_field() }}


                        <div class="row">

                            <div class="form-group col-lg-6">
                                <label>name<span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="name" value="{{ $data->name }}" placeholder="Game Name" required>
                                <span class="text-danger"> @error('name'){{ $message }}@enderror </span>
                            </div>

                            <div class="form-group col-lg-6">
                                <label>Announcement Date<span class="text-danger">*</span></label>
                                <input type="date" class="form-control" name="announcement_date" value="{{ $data->announcement_date }}" required>
                                <span class="text-danger"> @error('announcement_date'){{ $message }}@enderror </span>
                            </div>

                            <div class="form-group col-lg-6">
                                <label>Image</label>
                                <input type="file" class="form-control" name="image" id="image">
                                @if($data->image)
                                <img src="{{ url('/uploads/games/'.$data->image) }}" id="preview-image-before-upload" class="mt-2" height="100">
                                @else
                                <img id="preview-image-before-upload" height="100" class="mt-2">
                                @endif
                            </div>

                            <div class="text-center">
                                <button type="submit" class="btns primary-btn btn-sm">Update</button>
                            </div>

                        </div>

                    </form>

                </div>

            </div>

        </div>

    </div>    

</div>

</main><!-- End #main -->

 @endsection





