@extends('frontend.layouts.main')

@section('main-container')

<main id="main" class="main">

@include('cdn')

 <script src = "https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>

 <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>



<div class="container h-100" style="margin-top:10px;">

      

<h5>Assign Permissions</h5>

<div class="row">

         <form method="POST" action="{{route('role.store')}}">

            {{ csrf_field() }}

                <div class=" form-outline  mb-3" style="width:300px;">

                     <strong>Role<span style="color:red;">*</span></strong>

                       <select name="role_id" class=" form-control" style="text-transform:capitalize;" readonly>

                            <option value="{{ $role->id }}">{{$role->name}}</option>

                           

                         </select>

                        @error('role_id')

                        <div class="alert alert-danger mt-1 mb-1">{{ $message }}</div>

                        @enderror     

                </div>

               

              <div class="card" style="width:auto;">





                                        <table class="permissionTable table">

                                            <th>

                                                {{__('Section')}}

                                            </th>

                                

                                            <th>

                                                <label>

                                                    

                                                    {{__('Select All') }}

                                                </label>

                                            </th>

                                

                                            <th>

                                                {{__("Available permissions")}}

                                            </th>

                                

                                

                                           

                                            <tbody class="role-permission">

                                               @foreach($custom_permission as $key => $group)

                                                <tr>

                                                    <td>

                                                        <b>{{ ucfirst($key) }}</b>

                                                    </td>

                                                    <td width="30%">

                                                        <label>

                                                            <input class="selectall" onclick="selectAll(this.value)" value="{{$key}}" type="checkbox">

                                                            {{__('Select All') }}

                                                        </label>

                                                    </td>

                                                    <td>

                                                        

                                                        @forelse($group as $permission)

                                                            

                                                           <label >

                                                                @if(in_array($permission->id, $rolePermissions))

                                                                   <input name="permissions[]" class="permissioncheckbox {{$key}}" type="checkbox" value="{{$permission->name}}" checked>

                                                                   &nbsp; {{ucfirst($permission->name)}} &nbsp;&nbsp;

                                                                @else

                                                                    <input name="permissions[]" class="permissioncheckbox {{$key}}" type="checkbox" value="{{$permission->name}}">

                                                                   &nbsp; {{ucfirst($permission->name)}} &nbsp;&nbsp;

                                                                @endif

                                                           </label>

                                

                                                        @empty

                                                            {{ __("No permission in this group !") }}

                                                        @endforelse

                                

                                                    </td>

                                

                                                </tr>

                                               @endforeach

                                            </tbody>

                                        </table>





             </div>

             <div class="text-center">

                <button type="submit" class="btns primary-btn">Save</button> 

                <a href="{{url('/addroles')}}" class="btns primary-btn" style="color:white;">Back</a> 

             </div>   

         </form>     

</div>

</div>

</main>

<script type="text/javascript">

    function changeRole(argument) {



        $.ajax({

            url: 'onchangerole/'+ argument,

            type: 'Get',

            dataType: 'json',    

            success:function(response)

            {

               console.log($html);

                $('.role-permission').html(response);

            },

            error: function(response) {

            }

        });

        

    }

</script> 

<script>

    function selectAll(argument) {

       

        var cls = "."+argument;



        if($(cls).prop('checked')==true){

           

            $(cls).prop('checked', false);

        } else {

           

            $(cls).prop('checked', true); 

        }

        

    }

</script>



@endsection



