<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GamesResult extends Model
{
    use HasFactory;

    protected $fillable=['game_id','user_id','name','email','phone','address','attribute_id','label','value','question','answer','winners'];


    public function game()
    {

        return $this->hasOne(Games::class,'id','game_id');

    }

    public function attribute()
    {

        return $this->hasOne(Attribute::class,'id','attribute_id');

    }
}
