<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use App\Models\{User,Role,Group,State,City};

class UsersController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data['users'] = User::get();

        return view('users.index',$data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $data['role'] = Role::where('name', 'Employee')->get();
        $data['states'] =   State::where('country_id','101')->get();

        return view('users.create',$data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'name'      => 'required',
            'mobile'    => 'required',
            'email'     =>'required|email|unique:users,email',
        ]);

        $params['name']         =   $request->name;
        $params['email']        =   $request->email;
        $params['mobile']       =   $request->mobile;
        $params['DOB']          =   $request->dob;
        $params['role']         =   str_replace('_','',str_replace(Auth::user()->company_id,'',$request->role));
        $params['group']        =   $request->group;
        $params['password']     =   Hash::make($request->password);
        $params['headquater']   =   $request->headquater;
        $params['state']        =   $request->state;
        $params['city']         =   $request->city;
        $params['pincode']      =   $request->pincode;
        $params['bank_details'] =   $request->bank_details;
        $params['address']      =   $request->address;
        $params['company_id']   =   Auth::user()->company_id;
       
        $user=User::create($params);
        $user->assignRole($request->role);

        return redirect()->route('users')->with('success','Company Updated Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $id = decrypt($id);

        $user = User::find($id);

        if($user){

            $data['user'] = $user;
            
            return view('users.view',$data);
        } else {
            return redirect()->back()->with('error','User not found');
        }
        
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $id=decrypt($id);

        $user           =   User::find($id);
        $data['user']   =   $user;
        $data['role'] = Role::where('name', 'Employee')->get();
        $data['states'] =   State::where('country_id','101')->get();
        $data['cities'] =   City::where('state_id',$user->state)->get();

        return view('users.edit',$data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'name'      => 'required',
            'mobile'    => 'required',
            'email'     => 'required',
        ]);

        $user = User::find($id);
        if($user){
            $params['name']         =   $request->name;
            $params['email']        =   $request->email;
            $params['mobile']       =   $request->mobile;
            $params['DOB']          =   $request->dob;
            $params['role']         =   str_replace('_','',str_replace(Auth::user()->company_id,'',$request->role));
            $params['group']        =   $request->group;
            $params['state']        =   $request->state;
            $params['city']         =   $request->city;
            $params['pincode']      =   $request->pincode;
            $params['bank_details'] =   $request->bank_details;
            $params['address']      =   $request->address;
           
            $user->update($params);
            $user->assignRole($request->role);

            return redirect()->route('users')->with('success','User Updated Successfully');
        } else {
            return redirect()->back()->with('error','User not found');
        }
        
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $id=decrypt($id);

        $users=User::find($id);

        $users->delete();

        return redirect()->back()->with('error','User deleted successfully.');
    }

     public function driver()
    {
        return view('driver.index');
    }
}
