<?php

namespace App\Http\Controllers;

use App\Models\Report;

use App\Models\User;

use App\Models\Location;
use Illuminate\Http\Request;

class ReportController extends Controller
{
    public function index(Request $request)
    {
        $users = User::whereNotIn('role', ['Admin'])->get();
        $locations = Location::where('status', '1')->select('id', 'name')->get();
        
        $query = Report::query();
        
        if ($request->filled('user_id')) {
            $query->where('user_id', $request->user_id);
        }
        
        if ($request->filled('location')) {
            $query->where('location', $request->location);
        }
        
        if ($request->filled('date_from')) {
            $query->whereDate('created_at', '>=', $request->date_from);
        }
        
        if ($request->filled('date_to')) {
            $query->whereDate('created_at', '<=', $request->date_to);
        }
        
        $datas = $query->orderBy('id', 'DESC')->get();
        
        $data = [
            'users' => $users,
            'locations' => $locations,
            'datas' => $datas,
            'request' => $request,
        ];

        return view('report.index', $data);
    }



    public function create()
    {
         return view('report.create');
    }


    public function store(Request $request)
    {
        $this->validate($request,[
            'name'              => 'required',
        ]);

        $params['name']             = $request->name;

        $res = Report::create($params);
        if($res){
            return redirect()->route('reports')->with('success','Report Created Successfully');
        } else {
            return redirect()->back()->with('error','Try Again');
        }
    }

   
    public function edit($id)
    {

        $id=decrypt($id);

        $report          =   Report::find($id);

        $data['report']   =   $report;

        return view('report.edit',$data);
    }

   
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
        ]);

        $report = Report::find($id);
        if (!$report) {
            return redirect()->back()->with('error', 'Report not found');
        }

        $params['name'] = $request->name;
        $report->update($params);

        return redirect()->route('reports')->with('success', 'Report Updated Successfully');
    }


  
    public function destroy($id)
    {
        $id=decrypt($id);

        $report=Report::find($id);

        $report->delete();

        return redirect()->back()->with('error','Report deleted successfully.');
    }
}
