<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Location;

class LocationController extends Controller
{
   
    public function index()
    {
        $data['datas'] = Location::where('slug','terms')->get();

        return view('terms_conditions.index',$data);
    }

    public function create()
    {
        return view('terms_conditions.create');
    }

   
    public function edit($id)
    {

        $id=decrypt($id);

        $data         =   Location::find($id);
        $data['data']   =   $data;

        return view('terms_conditions.edit',$data);
    }

   
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'terms_condition' => 'required',
        ]);

        $location = Location::find($id);
        if (!$location) {
            return redirect()->back()->with('error', 'terms_condition not found');
        }

        $params['terms_condition'] = $request->terms_condition;
        $location->update($params);

        return redirect()->route('terms_conditions')->with('success', 'terms_condition Updated Successfully');
    }

}
