<?php

namespace App\Http\Controllers;

use App\Models\Games;

use App\Models\GamesQuestion;

use App\Models\Attribute;

use App\Models\GamesResult;

use Illuminate\Http\Request;

class GamesResultController extends Controller
{

    public function index()
    {

        $data['datas'] = Games::orderBy('Id', 'DESC')->get();

        return view('games_result.index',$data);
    }


    public function show_players_lists($id)
    {
        $id=decrypt($id);

        $data['games']=Games::where('id',$id)->first();

        $data['game_results'] = GamesResult::where('game_id',$id)->get();

        return view('games_result.show',$data);

    } 

    public function show_winners_lists($id)
    {
        $id=decrypt($id);

        $data['games']=Games::where('id',$id)->first();

        $data['game_results'] = GamesResult::where('game_id',$id)->where('winners','1')->get();

        return view('games_result.winners',$data);

    }


    public function game_winners($id)
    {
        $data = GamesResult::find($id);
        if ($data) {
            $winners = $data->winners == '1' ? '0' : '1';
            $data->update([
                'winners' => $winners
            ]);
            return back()->with('success', 'Winners updated successfully.');
        } else {
            return back()->with('error', 'Try Again.');
        }
    }

}
