<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\GamesQuestion;

use App\Models\Games;

class GamesQuestionController extends Controller
{
    public function index()
    {
        $data['games'] = Games::orderBy('Id', 'DESC')->get();

        $data['datas'] = GamesQuestion::orderBy('Id', 'DESC')->get();

        return view('games_questions.index',$data);
    }


     public function create(Request $request)
    {

        $data ['games'] = Games::orderBy('created_at','desc')->get();
        return view('games_questions.create',$data);
    }


    public function store(Request $request)
    {
        $this->validate($request,[
            'question'  => 'required',
        ]);

        $params['question']             = $request->question;

        $params['game_id']             = $request->game_id;

        $params['option_1']             = $request->option_1;

        $params['answer_1']             = $request->answer_1;

        $params['option_2']             = $request->option_2;

        $params['answer_2']             = $request->answer_2;

        $params['option_3']             = $request->option_3;

        $params['answer_3']             = $request->answer_3;

        $params['option_4']             = $request->option_4;

        $params['answer_4']             = $request->answer_4;

        $res = GamesQuestion::create($params);
        if($res){
            return redirect()->back()->with('success','games questions Created Successfully');
        } else {
            return redirect()->back()->with('error','Try Again');
        }
    }

   
    public function edit($id)
    {

        $id=decrypt($id);

        $data ['games'] = Games::orderBy('created_at','desc')->get();

        $game_question          =   GamesQuestion::find($id);

        $data['data']   =   $game_question;

        return view('games_questions.edit',$data);
    }

   
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'question' => 'required',
        ]);


        $game = GamesQuestion::find($id);
        if (!$game) {
            return redirect()->back()->with('error', 'games questions not found');
        }

        $params['question']             = $request->question;

        $params['option_1']             = $request->option_1;

        $params['answer_1']             = $request->answer_1;

        $params['option_2']             = $request->option_2;

        $params['answer_2']             = $request->answer_2;

        $params['option_3']             = $request->option_3;

        $params['answer_3']             = $request->answer_3;

        $params['option_4']             = $request->option_4;

        $params['answer_4']             = $request->answer_4;

        $game->update($params);

        return redirect()->back()->with('success', 'games questions Updated Successfully');
    }


  
    public function destroy($id)
    {
        $id=decrypt($id);

        $game=GamesQuestion::find($id);

        $game->delete();

        return redirect()->back()->with('error','games questions deleted successfully.');
    }




    public function game_active($id)
    {
        $data=GamesQuestion::find($id);
        if($data){
            if($data->status=='1'){
                $status='0';
            }else{
                $status='1';
            }
            $data->update([
                'status'=>$status
            ]);
            return back()->with('success', 'Status Update successfully.');
        } else {
            return back()->with('error', 'Try Again.');
        }     

    }    
}
