<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\Games;

use App\Models\GamesQuestion;

use App\Models\Attribute;

use App\Models\GamesResult;

class GamesController extends Controller
{
    public function index()
    {

        $data['datas'] = Games::orderBy('Id', 'DESC')->get();

        return view('games.index',$data);
    }


     public function create()
    {
        return view('games.create');
    }


    public function store(Request $request)
    {
        $this->validate($request,[
            'name'  => 'required',

            'image' => 'required',

            'announcement_date' => 'required',
        ]);

        if ($request->hasFile('image'))

        {

            $imageName = time() . '.' . $request->image->extension();

            $path = $request->image->move(public_path('/uploads/games/'), $imageName);

            $params['image'] = $imageName;

        }

        $params['name']             = $request->name;

        $params['announcement_date']      = $request->announcement_date;

        $res = Games::create($params);
        if($res){
            return redirect()->route('games')->with('success','game Created Successfully');
        } else {
            return redirect()->back()->with('error','Try Again');
        }
    }

   
    public function edit($id)
    {

        $id=decrypt($id);

        $game          =   Games::find($id);

        $data['data']   =   $game;

        return view('games.edit',$data);
    }

   
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
        ]);

        $game = Games::find($id);
        if (!$game) {
            return redirect()->back()->with('error', 'games not found');
        }

        $params['name'] = $request->name;

        $params['announcement_date'] = $request->announcement_date;

        if ($request->hasFile('image'))

        {

            $imageName = time() . '.' . $request->image->extension();
            $path = $request->image->move(public_path('/uploads/games/'), $imageName);
            $params['image'] = $imageName;
        }

        $game->update($params);

        return redirect()->route('games')->with('success', 'games Updated Successfully');
    }


  
    public function destroy($id)
    {
        $id=decrypt($id);

        $game=Games::find($id);

        $game->delete();

        return redirect()->back()->with('error','games deleted successfully.');
    }




    public function game_active($id)
    {
        $data=Games::find($id);
        if($data){
            if($data->status=='1'){
                $status='0';
            }else{
                $status='1';
            }
            $data->update([
                'status'=>$status
            ]);
            return back()->with('success', 'Status Update successfully.');
        } else {
            return back()->with('error', 'Try Again.');
        }     

    }


    public function show_question($id)
    {

        $id=decrypt($id);

        $data['games'] = Games::where('id',$id)->first();

        $data['datas'] = GamesQuestion::where('game_id',$id)->get();


        return view('games_questions.index',$data);
    }  

    public function show_attribute($id)
    {

        $id=decrypt($id);

        $data['games'] = Games::where('id',$id)->first();

        $data['attribute'] = Attribute::where('game_id',$id)->get();

        return view('games_attribute.index',$data);
    } 

      
}
