<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Attribute;

class AttributeController extends Controller
{
    public function store(Request $request)
    {
        $label = $request->input('label');
        $value = $request->input('value');
        $game_id = $request->input('game_id');

        foreach ($label as $index => $item) {
            $attribute = new Attribute();
            $attribute->label = $label[$index];
            $attribute->value = $value[$index];
            $attribute->game_id = $game_id;
            $attribute->save();
        }

        return redirect()->back()->with('success', 'Attributes added successfully');
    }

    public function update(Request $request, $id)
    {
        $attribute = Attribute::findOrFail($id);

        $attribute->label = $request->input('label');
        $attribute->value = $request->input('value');
        $attribute->save();
        return redirect()->back()->with('success', 'Attribute updated successfully');
    }


    public function destroy($id)
    {
        $id=decrypt($id);

        $attribute=Attribute::find($id);

        $attribute->delete();

        return redirect()->back()->with('error','attribute deleted successfully.');
    }

}





