<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Carbon\Carbon;
use DateTime;
use DatePeriod;
use DateInterval;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\DB;
use Illuminate\Mail\Mailable;
use App\Mail\DemoMail;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use App\Models\{Games,Attribute,GamesQuestion,GamesResult,Location};


class ApiController extends Controller
{

    public function Game_get(Request $request)
    {

        $startfrom = $request->input('startfrom', 1); 
        $totalrecords = $request->input('totalrecords', 10); 
        $games = Games::where('status', 1)->skip(($startfrom - 1) * $totalrecords)
            ->take($totalrecords)->orderBy('created_at', 'desc')
            ->get();

        if (!$games->isEmpty()) {
            $games->transform(function ($game) {
                return [
                    'id' => $game->id,
                    'name' => $game->name,
                    'image' => 'uploads/games/' . $game->image,
                    'status' => $game->status,
                    'announcement_date' => date('d-m-Y', strtotime($game->announcement_date)),
                    'created_at' => date('d-m-Y', strtotime($game->created_at))



                ];
            });

            return response()->json([
                'status' => 'true',
                'msg' => 'All Games',
                'data' => $games
            ], 200);
        } else {
            return response()->json([
                'status' => 'false',
                'msg' => 'No Games found',
            ], 200);
        }
    }


    public function Get_Attribute(Request $request)
    {
        $messages = array(
            'game_id.required' => 'game id is required',
        );

        $validator = Validator::make($request->all(), [
            'game_id' => 'required',
        ], $messages);

        if ($validator->fails()) {
            return response()->json([
                'result' => false,
                'message' => $validator->errors()
            ]);
        }

        $game_id = $request->input('game_id');

        $user_id = $request->input('user_id');

        $game_result = GamesResult::where('user_id',$user_id)->where('game_id', $game_id)->first();

        if ($game_result) {
            return response()->json([
                'status' => 'false',
                'msg' => 'You already played this game.',
            ], 400);
        }

        $games = Attribute::with('game')->where('game_id', $game_id)->get();

        if ($games->isEmpty()) {
            return response()->json([
                'status' => 'false',
                'msg' => 'Attribute Not found for this Game',
            ], 404);
        }

        $participants = [];
        foreach ($games as $game) {
            $participant = $game->id . '|' . $game->label . '|' . $game->value;
            $participants[] = $participant;
        }

        return response()->json([
            'status' => 'true',
            'msg' => 'Attribute retrieved successfully.',
            'data' => $participants,
        ], 200);
    }


    public function Get_Results(Request $request)
    {
        $messages = array(
            'game_id.required' => 'game id is required',
        );

        $validator = Validator::make($request->all(), [
            'game_id' => 'required',
        ], $messages);

        if ($validator->fails()) {
            return response()->json([
                'result' => false,
                'message' => $validator->errors()
            ]);
        }

        $game_id = $request->input('game_id');

        $game_result = GamesResult::with('game')->where('game_id', $game_id)->orderBy('winners','desc')->get();

        if ($game_result->isEmpty()) {
            return response()->json([
                'status' => 'false',
                'msg' => 'Game Result not found for this game.',
            ], 404);
        }

        return response()->json([
            'status' => 'true',
            'msg' => 'Game Result retrieved successfully.',
            'data' => $game_result,
        ], 200);
    }


    public function Get_Questions(Request $request)
    {
        $messages = array(
            'game_id.required' => 'game id is required',
        );
        
        $validator = Validator::make($request->all(), [
            'game_id' => 'required',
        ], $messages);

        if ($validator->fails()) {
            return response()->json([
                'result' => false,
                'message' => $validator->errors()
            ]);
        }

        $game_id = $request->input('game_id');
        $games_questions = GamesQuestion::where('game_id', $game_id)->get();

        if ($games_questions->isEmpty()) {
            return response()->json([
                'status' => 'false',
                'msg' => 'Questions not found for this game',
            ], 404);
        }

        $formatted_questions = [];
        foreach ($games_questions as $question) {
            $formatted_question = [
                'id' => $question->id,
                'question' => $question->question,
                'options' => [
                    $question->option_1,
                    $question->option_2,
                    $question->option_3,
                    $question->option_4,
                ],
                'correct_option' => $question->answer_1 === 'yes' ? $question->option_1 : (
                                        $question->answer_2 === 'yes' ? $question->option_2 : (
                                            $question->answer_3 === 'yes' ? $question->option_3 : (
                                                $question->answer_4 === 'yes' ? $question->option_4 : null
                                            )
                                        )
                                    ),
            ];

            $formatted_questions[] = $formatted_question;
        }

        return response()->json([
            'status' => 'true',
            'msg' => 'Questions retrieved successfully.',
            'data' => $formatted_questions,
        ], 200);
    }

    public function Play_Games_Store(Request $request)
    {

        $params['user_id'] = $request->user_id;
        $params['game_id'] = $request->game_id;
        $params['name']    = $request->name;
        $params['email'] = $request->email;
        $params['phone'] = $request->phone;
        $params['address']    = $request->address;
        $params['attribute_id'] = $request->attribute_id;
        $params['label'] = $request->label;
        $params['value']    = $request->value;

        $game_result = GamesResult::create($params);

        if ($game_result) {
            return response()->json([
                'status' => 'true',
                'id' => $game_result->id,
                'user_id' => $game_result->user_id,
                'game_id' => $game_result->game_id,
                'msg' => 'Thank you For Playing...',
            ], 200);
        } else {
            return response()->json([
                'status' => 'false',
                'msg' => 'Something Went Wrong..',
            ], 200);
        }
    }


    public function Play_Games_Result_Update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required',
            'question' => 'required',
            'answer' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'result' => false,
                'message' => $validator->errors()
            ]);
        }

        $id = $request->input('id');
        $game_result = GamesResult::find($id);

        if (!$game_result) {
            return response()->json([
                'result' => false,
                'message' => 'Game result not found'
            ]);
        }

        $game_result->question = $request->question;
        $game_result->answer = $request->answer;
        $game_result->save();

        return response()->json(['success' => 'Game result updated successfully'], 200);
    }



    public function Games_Result_Count(Request $request)
    {
        $games = Games::where('status', 1)->orderBy('created_at', 'desc')->get();

        $games->transform(function ($game) {
            $game_result = GamesResult::where('game_id', $game->id)->where('winners', '1')->get();
            $game_result_total_plays = GamesResult::where('game_id', $game->id)->get();
            $userCount = $game_result->count();
            $gameresulttotalplays = $game_result_total_plays->count();
            if ($userCount >= 1) {
                return [
                    'id' => $game->id,
                    'name' => $game->name,
                    'image' => 'uploads/games/' . $game->image,
                    'status' => $game->status,
                    'user_count' => $userCount,
                    'game_result_total_plays' => $gameresulttotalplays,
                    'announcement_date' => date('d-m-Y', strtotime($game->announcement_date)),
                    'created_at' => date('d-m-Y', strtotime($game->created_at))
                ];
            } else {
                return null;
            }
        });

        $games = $games->filter();

        if (!$games->isEmpty()) {
            return response()->json([
                'status' => 'true',
                'msg' => 'Games with Winners List found.',
                'data' => $games
            ], 200);
        } else {
            return response()->json([
                'status' => 'false',
                'msg' => 'No Games with Winners List found.',
            ], 200);
        }

    }

    public function Terms_Conditions(Request $request)
    {

        $terms_conditions = Location::get();

        if (!$terms_conditions->isEmpty()) {

            return response()->json([

                'status' => 'true',
                'msg' => 'Terms Conditions Retrieved Successfully',
                'terms_condition' => $terms_conditions

            ], 200);
        } else {

            return response()->json([

                'status' => 'false',
                'msg' => 'No Terms & Conditions Found...'

            ], 200);
        }
    }



}




